/*
 * animate.c -- these routines handle the actual animation of
 * the balls, and the throwing and catching of balls according
 * to the pattern.
 */
 
#include "juggle.h"
#include "proto.h"
#include "animate.h"

void animate(toss *pattern, int len, int numballs, ball_pic *pictures)
{
   thrown_ball *ball = (thrown_ball *)smalloc(numballs * sizeof(thrown_ball));
   register int         i, counter;
            int         place;
            side_t      side;
   register thrown_ball *x;
   register screenpt    *oldloc;
            side_t      oldside;

   for (i=0; i < numballs; i++) {
      ball[i].loc = NULL;
      ball[i].ballp = pictures+i;
      ball[i].timeleft = 0;
   }

   place = 0;
   side = RIGHT;

   clearkeyb();

   FOREVER {
      for (i=0; ball[i].timeleft && i < numballs; i++)
         ;
      if (i < numballs) {
         throw_ball( x=ball+i, pattern+place, side );
         drawball( x->ballp, *(x->loc), x->throw_side );
      }
      else if (pattern[place].height) {
         fprintf (stderr, "Internal error! -- no ball to throw!");
         exit(2);
      }

      for (counter=height_counts; counter--;)
         for (i=0; i < numballs; i++) {
            x = ball+i;
            if (!x->timeleft) continue;

   #ifdef NOXDRAW
            eraseball( x->ballp, *(x->loc++), x->throw_side );
   #else
            oldloc = x->loc++;
            oldside = x->throw_side;
   #endif

            if (--x->count)
               drawball( x->ballp, *(x->loc), x->throw_side );
            else if (counter || x->timeleft > 1) {
               x->loc = x->handloc;
               x->count = catch_counts;
               x->throw_side = x->catch_side;
               drawball( x->ballp, *(x->loc), x->throw_side );
            }

   #ifndef NOXDRAW
            eraseball( x->ballp, *oldloc, oldside );
   #endif

         }

      for (i=0; i < numballs; i++)
         if (ball[i].timeleft) ball[i].timeleft--;
      place = ++place % len;
      side = !side;
      if (keypressed()) {
         clearkeyb();
         break;
      }
   }
   free(ball);
}



void throw_ball(thrown_ball *ball, toss *throw, side_t side)
{
   ball->loc        = throw->path;
   ball->throw_side = side;
   ball->catch_side = (throw->height % 2) ? !side : side;
   ball->timeleft   = throw->height;
   ball->count      = throw->count;
   ball->handloc    = handpath [throw->to] [throw->nextfrom];
}
 