/*
 * juggle.c -- the main program.
 */ 

#include "juggle.h"
#include "proto.h"

/*
 * Global variable allocation and default values:
 */

int      height_counts = 12;
float    hold_beats    = 1.5;
int      catch_counts  = 18;
char     hold_two_flag = 1;
int      maxballs = 0;                      /* 0 -> no maximum */
screenpt *handpath[HANDPOS][HANDPOS];
windowpt hand[HANDPOS] = { -1.0,  0.0,      /* INSIDE  */
                           -1.75, 0.5 };    /* OUTSIDE */


int main(void)
{
   char        buffer[BUFLEN];
   int         numballs, len;
   float       max;
   ball_pic    *pictures;          /* pictures[numballs] */
   toss        *pattern;           /* pattern[len]       */

   FOREVER {
      numballs = 0;
      while (!numballs) {
         getpattern(buffer);
         if (*buffer == '\0') exit(0);
         if (*buffer == '?') {
            getoptions();
            continue;
         }
         pattern = parsepattern(buffer, &len);
         if (!pattern) continue;
         numballs = checkpattern(pattern, len);
      }

      setup_graphics();

      calccatchpos(pattern, len);
      max = calcpaths(pattern, len);
      calchandpaths(-GRAVITY * max / catch_counts * 5);
      pictures = makeballpix(numballs);

      printf ("Pattern: %s, %i balls.\n", buffer, numballs);
      animate(pattern, len, numballs, pictures);

      releaseballpix(pictures, numballs);
      releasepaths(pattern, len);
      free(pattern);

      exit_graphics();
   }
}

void *smalloc(size_t size)
{
   void *tmpptr = malloc(size);

   if (!tmpptr && size) {
      fprintf(stderr, "Malloc error: out of dynamic memory\n");
      exit(1);
   }

   return tmpptr;
}

