/* juggle.h */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

/*
 * defines:
 */

#define  BUFLEN   256
#define  GRAVITY  -4
#define  HANDPOS  2
#define  FOREVER  for (;;)
#define  YES      (1)
#define  NO       (0)
/*
 * enum types:
 */

typedef enum {INSIDE, OUTSIDE} pos_t;
typedef enum {LEFT, RIGHT}     side_t;

/*
 * data structures:
 */

typedef struct {
   int   x;
   int   y;
} screenpt;

typedef struct {
   float x;
   float y;
} windowpt;

typedef struct {              /* This structure may be modified to hold  */
   int      xoffset;          /* any other information needed to display */
   int      yoffset;          /* a ball given coordinates for its center */
   void far *picture;         /* (eg, raduis).  It may include pointers  */
   char     tofree;           /* to multiple bit-maps, for animation!    */
} ball_pic;

typedef struct {
   screenpt *loc;
   screenpt *handloc;
   side_t   throw_side;
   side_t   catch_side;
   ball_pic *ballp;
   int      count;
   int      timeleft;
} thrown_ball;

typedef struct {
   int      height;
   int      count;
   pos_t    from;
   pos_t    to;
   pos_t    nextfrom;
   screenpt *path;
   char     tofree;
} toss;


/*
 * global variables:
 */

extern int        height_counts;
extern float      hold_beats;
extern int        catch_counts;
extern char       hold_two_flag;
extern int        maxballs;
extern windowpt   hand[HANDPOS];
extern screenpt   *handpath[HANDPOS][HANDPOS];
