/*
 * pattern.c handles the reading and parsing of the pattern to be
 * juggled.
 */

#include "juggle.h"
#include "proto.h"
#include "pattern.h"

/*
 * local external variables
 */

static char *alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZ";

/*
 * parsepattern controlls the parsing of the juggling pattern.
 * It sets values for numballs and len, and returns a pointer to memory
 * it allocates and fills with parsed representation of the tosses.
 */
 
toss *parsepattern(char *buffer, int *len)
{
   toss *pattern;

   *len = patternlen(buffer);
   if (*len == 0)
      return(NULL);
   pattern = (toss *) smalloc (*len * sizeof(toss));

   if (!parse_throws(buffer, *len, pattern))
      return(NULL);

   return pattern;
}

/*
 * patternlen returns the number of tosses in the pattern, so parsepattern
 * can malloc the right about of memory to parse into.  It just counts the
 * number of alphanumerics, counts everything from a ( to the next ) as one
 * toss, and ignores all other characters.  No error-checking.
 */

int patternlen(char *c)
{
   int i=0;

   while (*c) {
      if (isalnum(*c))
         i++;
      else if (*c == '(' ) {
         i++;
         while (*++c != ')' )
            ;
      }
      c++;
   }
   return i;
}

/*
 * parse_throws fills the .height and .from fields of pattern array.
 * The pattern string is a series of tosses with optional white space
 * between them.  Each toss is either an alphanumeric, optionally followed
 * by a ', or a decimal number inside parens, optionally followed by a '
 * either inside or outside the close paren.  Ugly code.
 */

int parse_throws(char *c, int len, toss *pattern)
{
   int i, height;

   for (i=0; i < len; i++, pattern++) {
      pattern->from = INSIDE;
      while (isspace(*c))
         c++;
      if (isdigit(*c)) {
         pattern->height = *c - '0';
         if (*++c == '\'') {
            pattern->from = OUTSIDE;
            c++;
         }
      }
      else if (isalpha(*c)) {
         pattern->height = ALPHABETNUM(*c) + 9;
         if (*++c == '\'') {
            pattern->from = OUTSIDE;
            c++;
         }
      }
      else if (*c == '(' ) {
         if (!isdigit(*++c)) {
            printf ("Parse error: a ( must be followed by a digit\n");
            return(0);
         }
         for (height=0; isdigit(*c); c++)
            height = 10 * height + (*c - '0');
         pattern->height = height;

         if (*c == '\'') {
            pattern->from = OUTSIDE;
            c++;
         }
         if (*c++ != ')' ) {
            printf ("Parse error: expected ), but got %c\n", *--c);
            return(0);
         }
         if (*c == '\'' && pattern->from == INSIDE) {
            pattern->from = OUTSIDE;
            c++;
         }
      }
      else {
         printf ("Parse error: unexpected character %c\n", *c);
         return(0);
      }
   }
   while (isspace(*c))
      c++;
   if (*c != '\0') {
      printf ("Parse error: unexpected character %c\n", *c);
      return (0);
   }

   return(len);
}


/*
 * comppattern makes sure the parsed pattern is valid for juggling
 * (whole number of balls and don't have to catch two at once), and fills
 * in whether a given ball will be caught inside or outside the ball
 * being thrown at the same time.  Returns numballs, or 0 for error.
 */

int checkpattern(toss *pattern, int len)
{
   int i, j, sum=0;
   char *flag = (char *)smalloc(len);

   for (i=0; i < len; i++) {
      sum += pattern[i].height;
      flag[i]=0;
   }
   if (sum % len) {
      printf ("Not a whole number of balls!\n");
      free(flag);
      return 0;
   }

   for (i=0; i < len; i++) {
      j = (i + pattern[i].height) % len;
      if (flag[j]++) {
         printf ("Can only catch one ball at a time!\n");
         free(flag);
         return 0;
      }
   }
   free(flag);
   return (sum / len);
}

